<cfsilent>
<!--- Begin of Settings --->
<cfset variables.stiletto = StructNew()/>
<cfset variables.stiletto.storagedirectory = ""/>							<!---Need full path to an 'errors' directory, don't use expandpath() - this is debugging, so that would be relative--->
<cfset variables.stiletto.recordjusterrors = "false"/>						<!---If true will just record request errors, but in that case you might as well just use the cferror tag--->
<cfset variables.stiletto.maxsecondary = "100"/>							<!---Max secondary category by date desc--->
<cfset variables.stiletto.maxreportspersecondary = "100"/>					<!---Max reports per secondary category by date desc--->
<cfset variables.stiletto.primaryCategory = "#cgi.server_name#"/>			<!---You can choose to categorize errors by different vectors if needed --->
<cfset variables.stiletto.secondaryCategory = "#cgi.remote_addr#"/>			<!---You can choose to categorize errors by different vectors if needed --->
<cfset variables.stiletto.reportTemplate = "stiletto_layout_classic.cfm"/>	<!---You can switch out the layout for the reports--->
<cfset variables.stiletto.primarycategories = ""/>							<!---A simple comma delimited list of primary category areas you wish to trace, if left blank everything on server is traced--->
<!--- End of Settings --->

<cfset variables.stiletto.report = "Can't generate report. Debug template not found or has a fatal error."/>

<!---Set up the needed server.cfdebugger service--->
<cftry>
	<cfif structkeyexists(server,"cfdebugger") eq false>
		<cflock type="exclusive" timeout="3">
			<cfset server.cfdebugger = createObject("Java","coldfusion.server.ServiceFactory").getDebuggingService()/>
		</cflock>
	</cfif>
<cfcatch></cfcatch></cftry>

<cffunction name="reportDirectory" access="private" output="false" returntype="void">
	<cfargument name="storageDirectory" type="string" required="true"/>
	<cftry>	
		<cfif directoryexists(arguments.storageDirectory) eq false>
			<cfdirectory action="create" directory="#arguments.storageDirectory#"/>
		</cfif>
	<cfcatch></cfcatch></cftry>
</cffunction>

<cffunction name="cleanDirectory" access="private" output="false" returntype="void">
	<cfargument name="storageDirectory" type="string" required="true"/>
	<cfargument name="cutoff" type="numeric" required="true"/>
	<cfset var local = StructNew()/>
	<cftry>
		<cfdirectory action="list" directory="#arguments.storagedirectory#" name="local.list" sort="datelastmodified desc"/>
		<cfset local.ii = 1/>
		<cfloop query="local.list">
		<cfif local.ii gt arguments.cutoff>
			<cfif type eq "Dir">
				<cftry><cfdirectory action="delete" directory="#arguments.storagedirectory#/#name#" recurse="true"/><cfcatch></cfcatch></cftry>
			<cfelse>
				<cftry><cffile action="delete" file="#arguments.storagedirectory#/#name#"/><cfcatch></cfcatch></cftry>
			</cfif>
		</cfif>			
		<cfset local.ii = local.ii + 1/>
		</cfloop>
	<cfcatch></cfcatch></cftry>
</cffunction>

<cffunction name="writeReport" access="private" output="false" returntype="void">
	<cfargument name="primarycategory" type="string" required="true"/>
	<cfargument name="secondarycategory" type="string" required="true"/>
	<cfargument name="storageDirectory" type="string" required="true"/>
	<cfargument name="report" type="string" required="true"/>
	<cfset var local = StructNew()/>
	<cftry>	
		<cfset local.reportdir = "#trim(arguments.storagedirectory)#/#trim(primarycategory)#"/>
		<cfset reportDirectory(local.reportdir)/>
		<cfset cleanDirectory(local.reportdir,variables.stiletto.maxsecondary)/>
		
		<cfset local.reportdir = "#local.reportdir#/#trim(secondarycategory)#"/>
		<cfset reportDirectory(local.reportdir)/>
		<cfset cleanDirectory(local.reportdir,variables.stiletto.maxreportspersecondary)/>

		<cfset local.uuid = createUUID()/>
		<cffile action="write" file="#local.reportdir#/#local.uuid#.htm" output="#arguments.report#"/>
	<cfcatch></cfcatch>
	</cftry>
</cffunction>

</cfsilent>

<cfif directoryexists(variables.stiletto.storagedirectory)>
<cfif len(variables.stiletto.primarycategories) eq 0 or ListFindNoCase(variables.stiletto.primarycategories,variables.stiletto.primaryCategory,",") gt 0>
<cfif IsDebugMode()>
<cfsilent>
<cfset variables.startTime = getTickCount()>
	<cfset variables.qEvents = server.cfdebugger.getDebugger().getData()>

	<cfquery dbType="query" name="variables.cfdebug_templates" debug="false">
		SELECT template, parent, Sum(endTime - StartTime) AS et	FROM variables.qEvents WHERE type = 'Template' GROUP BY template, parent ORDER BY et DESC
	</cfquery>

	<cfquery dbType="query" name="variables.cfdebug_queries" debug="false">
		SELECT *, (endTime - startTime) AS executionTime FROM variables.qEvents	WHERE type = 'SqlQuery'
	</cfquery>
		
	<cfquery dbType="query" name="variables.cfdebug_storedproc" debug="false">
		SELECT *, (endTime - startTime) AS executionTime FROM variables.qEvents	WHERE type = 'StoredProcedure'
	</cfquery>
	
	<cfquery dbType="query" name="variables.cfdebug_trace" debug="false">
		SELECT * FROM variables.qEvents	WHERE type = 'Trace'
	</cfquery>
	
	<cfquery dbType="query" name="variables.cfdebug_timer" debug="false">
		SELECT * FROM variables.qEvents	WHERE type = 'CFTimer'
	</cfquery>
		
	<cfquery dbType="query" name="variables.cfdebug_ex" debug="false">
		SELECT * FROM variables.qEvents	WHERE type = 'Exception'
	</cfquery>
</cfsilent>

<cftry>
	<cfif variables.stiletto.recordjusterrors eq false or variables.cfdebug_ex.recordcount gt 0>
		<cfsavecontent variable="variables.stiletto.report"><cfinclude template="#variables.stiletto.reportTemplate#"/></cfsavecontent>
		<cfset writeReport(variables.stiletto.primarycategory,variables.stiletto.secondarycategory,variables.stiletto.storagedirectory,variables.stiletto.report)/>
	</cfif>
<cfcatch></cfcatch></cftry>

</cfif>
</cfif>
</cfif>