<!---The classic CF debug layout--->
<cfsetting enablecfoutputonly="Yes">
<cfset variables.reportStartTime = getTickCount()>

<!---Display Functions--->
<cffunction name="sortedScope" output="false">
    <cfargument name="title" required="true" type="String"/>
    <cfargument name="scope" required="true" type="Struct"/>
	<cfset var local = StructNew()/>
	
    <cfset local.retVal=""/>
    <cfset local.keys = structKeyArray(arguments.scope)/>
	<cfif arrayLen(local.keys) gt 0>
	    <cfset local.retVal="<p><table width=""60%""><tr><th colspan=""2"" align=""left"">#arguments.title#</th></tr>"/>
	    <cfset arraySort(local.keys,"text")/>
    	<cfloop index="local.x" from=1 to="#arrayLen(local.keys)#">
    		<cfset local.keyName = local.keys[local.x]/>
        	<cfset local.retVal = local.retVal & "<tr><td width=""250"" valign=""top"">" & local.keyName & "</td><td>"/>
            <cftry>
    		    <cfset local.keyValue = CFDebugSerializable(arguments.scope[local.keyName])/>
	    		<cfcatch><cfset local.keyValue = "undefined"/></cfcatch>
      	    </cftry>
        	<cfset local.retVal = local.retVal & local.keyValue & "</td></tr>"/>
    	</cfloop>
       	<cfset local.retVal = local.retVal & "</table></p>"/>
	</cfif>
    <cfreturn local.retVal>
</cffunction>

<cfscript>
//UDF - Handle output of complex data types.
function CFDebugSerializable(variable){
	var ret = "";
	try{
		if(IsSimpleValue(variable)){ 
			ret = xmlFormat(variable);
		}else{
			if (IsStruct(variable)){
				ret = ("Struct (" & StructCount(variable) & ")");
			}else if(IsArray(variable)){
				ret = ("Array (" & ArrayLen(variable) & ")");
			}else if(IsQuery(variable)){
				ret = ("Query (" & variable.RecordCount & ")");
			}else{
				ret = ("Complex type");
			}
		}
	}catch("any" ex){
        ret = "undefined";
    }
    return ret;
}

// UDF - tree writing
function drawNode(nTree, indent, id, highlightThreshold) {
    var templateOuput = "";
    if( nTree[id].duration GT highlightThreshold ) {
        templateOutput = "<font color='red'><span class='template_overage'>(#nTree[id].duration#ms) " & nTree[id].template & " @ line " & #nTree[id].line# & "</span></font><br>";
    } else {
        templateOutput = "<span class='template'>(#nTree[id].duration#ms) " & nTree[id].template & " @ line " & #nTree[id].line# & "</span><br>";
    }
    writeOutput(repeatString("&nbsp;&nbsp;&middot;", indent + 1) & " <img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/arrow.gif' alt='arrow' border='0'><img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/endDoc.gif' alt='top level' border='0'> " & templateOutput);
    return "";
}

function drawTree(tree, indent, id, highlightThreshold) {
    var alength = 1; 
    var i = 1;
    var templateOuput = "";

	if( structKeyExists(tree, id)){
	    // top level nodes (application.cfm,cgi.script_name,etc) have a -1 parent line number
	    if(tree[id].line EQ -1) {
			if( Tree[id].duration GT highlightThreshold){
	        	writeoutput( "<img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/topdoc.gif' alt='top level' border='0'> " & "<font color='red'><span class='template_overage'><b>(#Tree[id].duration#ms) " & Tree[id].template & "</b></span></font><br>" );
			}else{
				writeoutput( "<img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/topdoc.gif' alt='top level' border='0'> " & "<span class='template'><b>(#Tree[id].duration#ms) " & Tree[id].template & "</b></span><br>" );
			}
	    }else{
	        if( Tree[id].duration GT highlightThreshold){
	            templateOutput = "<font color='red'><span class='template_overage'>(#Tree[id].duration#ms) " & Tree[id].template & " @ line " & #Tree[id].line# & "</span></font><br>";
	        }else{
	            templateOutput = "<span class='template'>(#Tree[id].duration#ms) " & Tree[id].template & " @ line " & #Tree[id].line# & "</span><br>";
	        }
	        writeoutput( repeatString("&nbsp;&nbsp;&middot;", indent + 1) & " <img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/arrow.gif' alt='arrow' border='0'><img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/parentDoc.gif' alt='top level' border='0'> " & templateOutput );
	    }
	
	    if( isArray( tree[id].children ) and arrayLen( tree[id].children ) ) {
	        alength = arrayLen( tree[id].children );
	        for( i = 1; i lte alength; i = i + 1 ) {
	            if( isArray(tree[id].children[i].children) and arrayLen( tree[id].children[i].children ) gt 0 ) {
	                drawTree(tree, indent + 1, tree[id].children[i].templateid, highlightThreshold);
	            }else{
	                drawNode(tree, indent + 1, tree[id].children[i].templateid, highlightThreshold);
	            }
	        }
	    }
	}
    return "";
}
</cfscript>

<cfoutput>
<style type="text/css">
.cfdebug {color:black;background-color:white;font-family:"Times New Roman", Times, serif;font-size:small;}
.cfdebuglge{color:black;background-color:white;font-family:"Times New Roman", Times, serif;font-size:medium;}
a.cfdebuglink {color:blue; background-color:white }
</style>

<html><body>
</cfoutput>

<cfif server.cfdebugger.settings.general>
<cfoutput>
		<p class="cfdebug"><hr/>
		<b class="cfdebuglge"><a name="cfdebug_top">Debugging Information</a></b>
		<table class="cfdebug">
		<tr><td class="cfdebug" nowrap>#server.coldfusion.productname# #server.coldfusion.productlevel#</td><td class="cfdebug">#server.coldfusion.productversion#</td></tr>
		<tr><td class="cfdebug" nowrap> Template </td><td class="cfdebug">#xmlFormat(CGI.Script_Name)#</td></tr>
		<tr><td class="cfdebug" nowrap> Time Stamp </td><td class="cfdebug">#DateFormat(Now())# #TimeFormat(Now())#</td></tr>
		<tr><td class="cfdebug" nowrap> Locale </td><td class="cfdebug">#GetLocale()#</td></tr>
		<tr><td class="cfdebug" nowrap> User Agent </td><td class="cfdebug">#CGI.HTTP_USER_AGENT#</td></tr>
		<tr><td class="cfdebug" nowrap> Remote IP </td><td class="cfdebug">#CGI.REMOTE_ADDR#</td></tr>
		<tr><td class="cfdebug" nowrap> Host Name </td><td class="cfdebug">#CGI.REMOTE_HOST#</td></tr>
		</table>
		</p>
</cfoutput>
</cfif>

<!--- Template Stack and Executions Times --->
  	<!--- Total Execution Time of all top level pages --->
  	<cfquery dbType="query" name="cfdebug_execution" debug="false">
      	SELECT (endTime - startTime) AS executionTime FROM variables.qEvents WHERE type = 'ExecutionTime'
  	</cfquery>
	<!--- ::	
		in the case that no execution time is recorded. 
		we will add a value of -1 so we know that a problem exists but the template continues to run properly.	
		:: --->
	<cfif not cfdebug_execution.recordCount>
		<cfscript>
			queryAddRow(cfdebug_execution);
			querySetCell(cfdebug_execution, "executionTime", "-1");
		</cfscript>
	</cfif>
	
  	<cfquery dbType="query" name="cfdebug_top_level_execution_sum" debug="false">
  		SELECT sum(endTime - startTime) AS executionTime FROM variables.qEvents	WHERE type = 'Template' AND parent = ''
  	</cfquery>

    <!--- File not found will not produce any records when looking for top level pages --->
    <cfif cfdebug_top_level_execution_sum.recordCount and len(trim(cfdebug_top_level_execution_sum.executionTime[1])) gt 0>
        <cfset time_other = Max(cfdebug_execution.executionTime - val(cfdebug_top_level_execution_sum.executionTime), 0)>    
        <cfoutput>
			<style type="text/css">
            .template{color: black; font-family: "Times New Roman", Times, serif;	font-weight: normal;}
			.template_overage{color: red;background-color: white;font-family: "Times New Roman", Times, serif;font-weight: bold; }
            </style>
       		<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_execution">Execution Time</a></b></p>
            <a name="cfdebug_templates">
        </cfoutput>
            
        <cfif server.cfdebugger.settings.template_mode EQ "tree">
            <cfset a = arrayNew(1)>
            <cfloop query="variables.qEvents">
               <cfscript>
                    // only want templates, IMQ of SELECT * ...where type = 'template' will result
                    // in cannot convert the value "" to a boolean for cachedquery column
                    // SELECT stacktrace will result in Query Of Queries runtime error.
                    // Failed to get meta_data for columnqEvents.stacktrace .
                    // Was told I need to define meta data for debugging event table similar to <cfldap>
                    if( qEvents.type eq "template" ) {
                        st = structNew();
                        st.StackTrace = qEvents.stackTrace;
                        st.template = qEvents.template;
                        st.startTime = qEvents.starttime;
                        st.endTime = qEvents.endtime;
                        st.parent =  qEvents.parent;
                        st.line =  qEvents.line;
                        
                        arrayAppend(a, st);
                    }
               </cfscript>
            </cfloop>
            <cfset qTree = queryNew("template,templateId,parentId,duration,line")>
            <cfloop index="i" from="1" to="#arrayLen(a)#">
                <cfset childidList = "">
                <cfset parentidList = "">
                <cfloop index="x" from="#arrayLen(a[i].stacktrace.tagcontext)#" to="1" step="-1">
                    <cfscript>
                        if( a[i].stacktrace.tagcontext[x].id NEQ "CF_INDEX" ) {
                            // keep appending the line number from the template stack to form a unique id
                            childIdList = listAppend(childIdList, a[i].stacktrace.tagcontext[x].line);
                            if( x eq 1 ) {
                                parentIdList = listAppend(parentIdList, a[i].stacktrace.tagcontext[x].template);
                            } else {
                                parentIdList = listAppend(parentIdList, a[i].stacktrace.tagcontext[x].line);
                            }
                        }
                    </cfscript>
                </cfloop>
            
                <cfscript>
                    // template is the last part of the unique id...12,5,17,c:\wwwroot\foo.cfm
                    // if we don't remove the "CFC[" prefix, then the parentId and childId relationship
                    // will be all wrong
                    startToken = "CFC[ ";
                    endToken = " | ";
                    thisTemplate = a[i].template;
                    startTokenIndex = FindNoCase(startToken, thisTemplate, 1);
                    if( startTokenIndex NEQ 0 ) {
                        endTokenIndex = FindNoCase(endToken, thisTemplate, startTokenIndex);
                        thisTemplate = Trim(Mid(thisTemplate,Len(startToken),endTokenIndex-Len(startToken)));
                    }
                    childIdList = listAppend(childIdList, thisTemplate);
                    
                    queryAddRow(qTree);
                    querySetCell(qTree, "template", a[i].template);    
                    querySetCell(qTree, "templateId", childIdList);    
                    querySetCell(qTree, "parentId", parentIdList);    
                    querySetCell(qTree, "duration", a[i].endtime - a[i].starttime);    
                    querySetCell(qTree, "line", a[i].line);    
                </cfscript>
            </cfloop>
            
            <cfset stTree = structNew()>
            <cfloop query="qTree">
                <cfscript>
                // empty parent assumed to be top level with the exception of application.cfm
                if( len(trim(parentId)) eq 0 ){
                    parentId = 0;
                }
                    stTree[parentId] = structNew();
                    stTree[parentId].templateId = qTree.templateId;
                    stTree[parentId].template = qTree.template;
                    stTree[parentId].duration = qTree.duration;
                    stTree[parentId].line = qTree.line;
                    stTree[parentId].children = arrayNew(1);
                </cfscript>
            </cfloop>
            <cfloop query="qTree">
                <cfscript>
                    stTree[templateId] = structNew();
                    stTree[templateId].templateId = qTree.templateId;
                    stTree[templateId].template = qTree.template;
                    stTree[templateId].duration = qTree.duration;
                    stTree[templateId].line = qTree.line;
                    stTree[templateId].children = arrayNew(1);
                </cfscript>
            </cfloop>
            <cfloop query="qTree">
                <cfscript>
                    arrayAppend(stTree[parentId].children, stTree[templateId]);
                </cfscript>
            </cfloop>
            
            <cfquery dbType="query" name="topNodes" debug="false">
                SELECT parentId, templateid FROM qTree WHERE parentId = ''
            </cfquery>
           
            <cfoutput query="topNodes">
                #drawTree(stTree,-1,topNodes.templateid,server.cfdebugger.settings.template_highlight_minimum)#
            </cfoutput> 
            <cfoutput><p class="template">
                (#time_other# ms) STARTUP, PARSING, COMPILING, LOADING, &amp; SHUTDOWN<br />
                (#cfdebug_execution.executionTime# ms) TOTAL EXECUTION TIME<br />
                <font color="red"><span class="template_overage">red = over #server.cfdebugger.settings.template_highlight_minimum# ms execution time</span></font>
                </p></cfoutput>
        <cfelse>
        	<cftry>
                <cfquery dbType="query" name="cfdebug_templates_summary" debug="false">
	                SELECT  template, Sum(endTime - startTime) AS totalExecutionTime, count(template) AS instances
	                FROM variables.qEvents
	                WHERE type = 'Template'
	                group by template
	                order by totalExecutionTime DESC
                </cfquery>
                <cfoutput>
                <table border="1" cellpadding="2" cellspacing="0" class="cfdebug">
                <tr>
					<td class="cfdebug" align="center"><b>Total Time</b></td>
					<td class="cfdebug" align="center"><b>Avg Time</b></td>
					<td class="cfdebug" align="center"><b>Count</b></td>
					<td class="cfdebug"><b>Template</b></td>
				</tr>
                </cfoutput>
        
                <cftry>
                    <cfoutput query="cfdebug_templates_summary">
                        <cfset templateOutput = template>
                        <cfset templateAverageTime = Round(totalExecutionTime / instances)>
                        
                        <cfif template EQ ExpandPath(cgi.script_name)>
                            <cfset templateOutput = "<img src='#getpageContext().getRequest().getContextPath()#/CFIDE/debug/images/topdoc.gif' alt='top level' border='0'> " &
                                "<b>" & template & "</b>">
							 <cfif templateAverageTime GT server.cfdebugger.settings.template_highlight_minimum>
                                <cfset templateOutput = "<font color='red'><span class='template_overage'>" & template & "</span></font>">
                                <cfset templateAverageTime = "<font color='red'><span class='template_overage'>" & templateAverageTime & "</span></font>">
								<cfset totalTime = "<font color='red'><span class='template_overage'>" & totalExecutionTime & "</span></font>">
                            </cfif>
                        <cfelse>
                            <cfif templateAverageTime GT server.cfdebugger.settings.template_highlight_minimum>
                                <cfset templateOutput = "<font color='red'><span class='template_overage'>" & template & "</span></font>">
                                <cfset templateAverageTime = "<font color='red'><span class='template_overage'>" & templateAverageTime & "</span></font>">
								<cfset totalTime = "<font color='red'><span class='template_overage'>" & totalExecutionTime & "</span></font>">
                            </cfif>
                        </cfif>
    
                        <tr>
							<cfif isDefined("totalTime") and len(trim(totalTime))>
								<td align="right" class="cfdebug" nowrap>#totalTime# ms</td>
								<cfset totalTime = "">
							<cfelse>
    	                        <td align="right" class="cfdebug" nowrap>#totalExecutionTime# ms</td>
							</cfif>
                            <td align="right" class="cfdebug" nowrap>#templateAverageTime# ms</td>
                            <td align="center" class="cfdebug" nowrap>#instances#</td>
                            <td align="left" class="cfdebug" nowrap>#templateOutput#</td>
                        </tr>
                        </cfoutput>
                	<cfcatch type="Any"></cfcatch>
                </cftry>
                <cfoutput>
                <tr>
					<td align="right" class="cfdebug" nowrap><i>#time_other# ms</i></td><td colspan=2>&nbsp;</td>
                    <td align="left" class="cfdebug"><i>STARTUP, PARSING, COMPILING, LOADING, &amp; SHUTDOWN</i></td>
				</tr>
                <tr>
					<td align="right" class="cfdebug" nowrap><i>#cfdebug_execution.executionTime# ms</i></td><td colspan=2>&nbsp;</td>
                    <td align="left" class="cfdebug"><i>TOTAL EXECUTION TIME</i></td>
				</tr>
                </table>
                <font color="red"><span class="template_overage">red = over #server.cfdebugger.settings.template_highlight_minimum# ms average execution time</span></font>
                </a>
            	</cfoutput>
        	<cfcatch></cfcatch>
        	</cftry>
        </cfif>
    <cfelse>
        <p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_execution">Execution Time</a></b></p>
        <a name="cfdebug_templates">
        No top level page was found.
    </cfif> <!--- if top level templates are available --->

<!--- Exceptions --->
<cfif variables.cfdebug_ex.recordCount gt 0>
<cftry>
<cfoutput>
	<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_exceptions">Exceptions</a></b></p>
	<cfloop query="variables.cfdebug_ex">
	    <div class="cfdebug">#TimeFormat(variables.cfdebug_ex.timestamp, "HH:mm:ss.SSS")# - #variables.cfdebug_ex.name# <cfif FindNoCase("Exception", variables.cfdebug_ex.name) EQ 0>Exception</cfif> - in #variables.cfdebug_ex.template# : line #variables.cfdebug_ex.line#</div>
	    <cfif IsDefined("variables.cfdebug_ex.message") AND Len(Trim(variables.cfdebug_ex.message)) GT 0>
	    <pre>
	    #variables.cfdebug_ex.message#
	    </pre>
	    </cfif>
	</cfloop>
</cfoutput>
<cfcatch></cfcatch>
</cftry>
</cfif>

<!--- SQL Queries --->
<cfoutput>
<cfif variables.cfdebug_queries.RecordCount gt 0>
	<cftry>
		<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_sql">SQL Queries</a></b></p>
		<cfloop query="cfdebug_queries">
			<code><b>#cfdebug_queries.name#</b> (Datasource=#cfdebug_queries.datasource#, Time=#Max(cfdebug_queries.executionTime, 0)#ms<cfif IsDefined("cfdebug_queries.rowcount") AND IsNumeric(cfdebug_queries.rowcount)>, Records=#Max(cfdebug_queries.rowcount, 0)#<cfelseif IsDefined("cfdebug_queries.result.recordCount")>, Records=#cfdebug_queries.result.recordCount#</cfif><cfif cfdebug_queries.cachedquery>, Cached Query</cfif>) in #cfdebug_queries.template# @ #TimeFormat(cfdebug_queries.timestamp, "HH:mm:ss.SSS")#</code><br />
			<pre>#htmleditformat(cfdebug_queries.body)#</pre>
			
			<cfif arrayLen(cfdebug_queries.attributes) GT 0>
			    <code>Query Parameter Value(s) -<br />
			
			    <cfloop index="x" from=1 to="#arrayLen(cfdebug_queries.attributes)#">
	        		<cfset thisParam = #cfdebug_queries.attributes[cfdebug_queries.currentRow][x]#>
			        Parameter ###x#<cfif StructKeyExists(thisParam, "sqlType")>(#thisParam.sqlType#)</cfif> = <cfif StructKeyExists(thisParam, "value")>#htmleditformat(thisParam.value)#</cfif><br />
			    </cfloop>
			    </code><br />
			</cfif>
		</cfloop>
	<cfcatch></cfcatch>
</cftry>
</cfif>
	
<!--- Stored Procs --->
<cfif variables.cfdebug_storedproc.RecordCount gt 0>
<cftry>
<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_storedproc">Stored Procedures</a></b></p>
<p class="cfdebug">
<cfloop query="cfdebug_storedproc">
<!--- Output stored procedure details, remember, include result (output params) and attributes (input params) columns --->
<code><b>#cfdebug_storedproc.name#</b> (Datasource=#cfdebug_storedproc.datasource#, Time=#Max(cfdebug_storedproc.executionTime, 0)#ms) in #cfdebug_storedproc.template# @ #TimeFormat(cfdebug_storedproc.timestamp, "HH:mm:ss.SSS")#</code><br />
    <table border=0 cellpadding=0 cellspacing=0>
    <tr>
        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
        <td>
            <table border=1 cellpadding=2 cellspacing=2>
            <tr bgcolor="gray"><td colspan="5" align="center"><font color="white">parameters</font></td></tr>
            <tr><td><code><i>type</i></code></td><td><code><i>CFSQLType</i></code></td><td><code><i>value</i></code></td><td><code><i>variable</i></code></td><td><code><i>dbVarName</i></code></td></tr>
            
            <cfloop index="x" from=1 to="#arrayLen(cfdebug_storedproc.attributes)#">
            <cfset thisParam = #cfdebug_storedproc.attributes[cfdebug_storedproc.currentRow][x]#>
            <tr>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "type")>#thisParam.type#</cfif></code></td>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "sqlType")>#thisParam.sqlType#</cfif></code></td>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "value")>#htmleditformat(thisParam.value)#</cfif></code></td>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "variable")>#thisParam.variable# = #CFDebugSerializable(thisParam.variable)#</cfif></code></td>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "dbVarName")>#thisParam.dbVarName#</cfif></code></td>
            </tr>
            </cfloop>
            </table>
        </td>
    </tr><tr>
        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
        <td>
            <table border=1 cellpadding=2 cellspacing=2>
            <tr bgcolor="gray"><td colspan="5" align="center"><font color="white">resultsets</font></td></tr>
            <tr><td><code><i>name</i></code></td><td><code><i>resultset</i></code></td></tr>
            
            <cfloop index="x" from=1 to="#arrayLen(cfdebug_storedproc.result)#">
            <cfset thisParam = #cfdebug_storedproc.result[cfdebug_storedproc.currentRow][x]#>
            <tr>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "name")>#thisParam.name#</cfif></code></td>
                <td>&nbsp;<code><cfif StructKeyExists(thisParam, "resultSet")>#thisParam.resultSet#</cfif></code></td>
            </tr>
            </cfloop>
            </table>
        </td>
    </tr>
    </table>
</cfloop>
</p>
<cfcatch></cfcatch></cftry>
</cfif>

<!--- :: CFTimer :: --->
<cfif variables.cfdebug_timer.recordCount gt 0>
<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_timer">CFTimer Times</a></b></p>
<p class="cfdebug">

<cfloop query="variables.cfdebug_timer">
    <cftry>
    	#variables.cfdebug_timer.priority# type - [#val(variables.cfdebug_timer.endTime) - val(variables.cfdebug_timer.startTime)#ms] <i>#variables.cfdebug_timer.message#</i><br />
    <cfcatch></cfcatch></cftry>
</cfloop>
</p>
</cfif>

<!--- Tracing --->
<cfif variables.cfdebug_trace.recordCount gt 0>
<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_trace">Trace Points</a></b></p>
<p class="cfdebug">

<cfset variables.firstTrace=true>
<cfset variables.prevDelta=0>
<cfloop query="variables.cfdebug_trace">
    <cfset variables.deltaFromRequest = Val(variables.cfdebug_trace.endTime)>
    <cfset variables.deltaFromLast = Val(variables.deltaFromRequest-variables.prevDelta)>
    <cftry>
    	#variables.cfdebug_trace.priority# type - [#TimeFormat(variables.cfdebug_trace.timestamp, "HH:mm:ss.lll")# #variables.cfdebug_trace.template# @ line: #variables.cfdebug_trace.line#] [#variables.deltaFromRequest# ms (<cfif variables.firstTrace>1st trace<cfelse>#variables.deltaFromLast# ms</cfif>)] - <cfif #variables.cfdebug_trace.category# NEQ "">[#variables.cfdebug_trace.category#]</cfif> <cfif #variables.cfdebug_trace.result# NEQ "">[#variables.cfdebug_trace.result#]</cfif> <i>#variables.cfdebug_trace.message#</i><br />
    <cfcatch></cfcatch></cftry>
    <cfset variables.prevDelta = variables.deltaFromRequest>
    <cfset variables.firstTrace=false>
</cfloop>
</p>
</cfif>

<!--- SCOPE VARIABLES --->
<p class="cfdebug"><hr/><b class="cfdebuglge"><a name="cfdebug_scopevars">Scope Variables</a></b></p>

<cfif IsDefined("APPLICATION") AND server.cfdebugger.check("ApplicationVar")>#sortedScope("Application Variables",application)#</cfif>
<cfif IsDefined("CGI") AND server.cfdebugger.check("CGIVar")>#sortedScope("CGI Variables",cgi)#</cfif>
<cfif IsDefined("CLIENT") AND server.cfdebugger.check("ClientVar")>#sortedScope("Client Variables",client)#</cfif>
<cfif IsDefined("COOKIE") AND server.cfdebugger.check("CookieVar")>#sortedScope("Cookie Variables",cookie)#</cfif>
<cfif IsDefined("FORM") AND server.cfdebugger.check("FormVar")>#sortedScope("Form Fields",form)#</cfif>
<cfif IsDefined("REQUEST") AND server.cfdebugger.check("RequestVar")>#sortedScope("Request Parameters",request)#</cfif>
<cfif IsDefined("SERVER") AND server.cfdebugger.check("ServerVar")>#sortedScope("Server Variables",server)#</cfif>
<cfif IsDefined("SESSION") AND server.cfdebugger.check("SessionVar")>#sortedScope("Session Variables",session)#</cfif>
<cfif IsDefined("URL") AND server.cfdebugger.check("URLVar")>#sortedScope("URL Parameters",url)#</cfif>

<p>
<font size="-1" class="cfdebug"><i>Total Debug Rendering Time: #getTickCount() - variables.startTime# ms</i></font><br />
<font size="-1" class="cfdebug"><i>Debug Report Rendering Time: #getTickCount() - variables.reportstartTime# ms</i></font><br />
</p>
</body>
</html>
</cfoutput>	
<cfsetting enablecfoutputonly="No">
